/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.configuration;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.data.codec.requirement.EntityRequirement;
import com.momosoftworks.coldsweat.util.serialization.ConfigHelper;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Registry;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.registries.ForgeRegistries;

public record MountData(List<Either<TagKey<EntityType<?>>, EntityType<?>>> entities, double coldInsulation, double heatInsulation, EntityRequirement requirement, Optional<List<String>> requiredMods) {
    public static Codec<MountData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ConfigHelper.tagOrForgeRegistryCodec(Registry.f_122903_, ForgeRegistries.ENTITY_TYPES).listOf().fieldOf("entities").forGetter(MountData::entities), (App)Codec.DOUBLE.fieldOf("cold_insulation").forGetter(MountData::coldInsulation), (App)Codec.DOUBLE.fieldOf("heat_insulation").forGetter(MountData::heatInsulation), (App)EntityRequirement.getCodec().fieldOf("entity").forGetter(MountData::requirement), (App)Codec.STRING.listOf().optionalFieldOf("required_mods").forGetter(MountData::requiredMods)).apply((Applicative)instance, MountData::new));

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("MountData{entities=[");
        for (Either<TagKey<EntityType<?>>, EntityType<?>> entity : this.entities) {
            if (entity.left().isPresent()) {
                builder.append("#").append(((TagKey)entity.left().get()).toString());
            } else {
                builder.append(((EntityType)entity.right().get()).toString());
            }
            builder.append(", ");
        }
        builder.append("], coldInsulation=").append(this.coldInsulation).append(", heatInsulation=").append(this.heatInsulation).append(", requirement=").append(this.requirement);
        this.requiredMods.ifPresent(mods -> builder.append(", requiredMods=").append(mods));
        builder.append("}");
        return builder.toString();
    }
}

